function drawLoop()
{
	if (system.actions.length > 0)
	{
		if (system.actions[0].type == "Message")
		{
			drawMessage(system.actions[0]);
		}
	}
}

function updateLoop()
{
	if (system.actions.length > 0)
	{
		if (system.actions[0].type == "Message")
		{
			if (!system.actions[0].active)
			{
				system.actions[0].active = true;
				system.actions[0].time = GetTime();
				DetachInput();
			}
			updateMessage(system.actions[0]);
		}
	}
	// Check for poison!
}

// Message functions
// Draws message on screen
function drawMessage(message)
{
	window.drawWindow(12, 28, 296, 48, "MESSAGE");
	if (message.speaker == undefined)
	{
		font.messageText(12, 28, 296, 48, message.text.substr(0, message.current), message.thought);
	}
	else if (message.speaker != undefined)
	{
		font.drawText(12, 28, message.speaker);
		font.messageText(12, 40, 296, 36, message.text.substr(0, message.current), message.thought);
	}
	if (message.done)
	{
		font.littleText(286, 76, "NEXT");
	}
}

// Updates message
function updateMessage(message)
{
	if (!message.done)
	{
		if (message.current < message.lastSpace)
		{
			var letters = Math.floor((GetTime() - message.time) / system.fieldMessageSpeed);
			if (letters > 0)
			{
				message.current += letters;
				if (message.current >= message.lastSpace)
				{
					message.current = message.lastSpace;
					message.done = true;
				}
				message.time = GetTime();
			}
		}
	}
}

// Continues message
function continueMessage(message)
{
	if (message.done)
	{
		if (message.lastSpace < message.text.length)
		{
			message.text = message.text.substr(message.lastSpace + 1);
			message.current = 0;
			message.lastSpace = getSpaces(message.text, message.h);
			message.done = false;
			message.time = GetTime();
		}
		else
		{
			system.actions.shift();
			if (system.actions.length == 0)
			{
				AttachInput("Player");
			}
		}
	}
}

// Places message into message queue
function addMessage(text, speaker, thought)
{
	var message = new Object();
	message.text = "\"" + text + "\"";
	message.current = 0;
	message.done = false;
	message.active = false;
	message.speaker = speaker;
	message.thought = thought;
	message.time = 0;
	if (speaker != undefined)
	{
		 message.h = 36;
	}
	else
		message.h = 48;
	message.lastSpace = getSpaces(message.text, message.h);
	message.type = "Message";
	system.actions[system.actions.length] = message;
}

function AcceptKey()
{
	if (system.actions.length > 0)
	{
		if (system.actions[0].done && system.actions[0].type == "Message")
		{
			continueMessage(system.actions[0]);
		}
	}
}

function getSpaces(text, h)
{
	var spaces = new Array();
	var lastSpace = 0;
	for (var i = 0; i < text.length; i ++)
	{
		if (text.substr(i, 1) == " ")
		{
			spaces[spaces.length] = i;
		}
	}
	for (var i = 0; i < spaces.length; i ++)
	{
		if (font.main.getStringHeight(text.substr(0, spaces[i]), 296) > h)
		{
			lastSpace = spaces[i - 1];
			break;
		}
	}
	if (lastSpace == 0)
	{
		lastSpace = text.length;
	}
	return lastSpace;
}

function Say(id)
{
	var file = OpenFile("text.dat");
	addMessage(file.read("D" + id + ":Text", ""), file.read("D" + id + ":Speaker", ""), file.read("D" + id + ":Thought", 0));
}

function isReady()
{
	if (system.actions.length == 0)
	{
		return true;
	}
	return false;
}